Getting started with Bonnie is designed to be as painless as possible, and this page will outline the steps you'll need to perform to have a fully functional command aliasing setup in your projects!

## Installation

If you have `cargo` (Rust's package manager), you can skip this and install Bonnie with `cargo install bonnie`. Then run `bonnie -v` to get the version you're running to make sure everything works. Otherwise, read on.

1. Go to the [releases page](https://github.com/arctic-hen7/bonnie/releases).
2. Click on the executable file you want for your operating system (Windows, MacOS, Linux, and musl are supported by default). If the executable you want isn't there, you can clone the entire project to your local machine with `git clone https://github.com/arctic-hen7/bonnie.git` and run `cargo build --release && mv target/release/bonnie ./bonnie` (you'll need Rust installed, follow [this](https://www.rust-lang.org/tools/install) guide for that). This will build Bonnie for your operating system and give you the executable in the root of the project. Then, continue with the steps below!
3. Once you have the executable file, move it to somewhere from which you can easily access it. On Linux, this would probably be `/usr/local/bin` or similar. This process should be the same as installing any other CLI tool.
4. Now check that you can run Bonnie from your terminal by running `bonnie -v`, which should print the version of Bonnie that you have! If it doesn't, you may need to retrace your steps!

## Bonnie Configuration

Bonnie is configured in `bonnie.toml` on a per-folder basis. If you haven't used TOML before, it's like a more readable form of JSON or YAML designed more for humans than machines. You can read more about TOML [here](https://toml.io).

If there's already a `bonnie.toml` file in the directory where you run Bonnie, it will be parsed and Bonnie will expect you to provide a command to run. If you run `bonnie` and it tells you you need to provide a command, then there's a valid `bonnie.toml` in the directory! If not, you can create a new configuration file with `bonnie -i`. If you have a particular layout of Bonnie configuration that you regularly use, you can put it somewhere and run `bonnie -t --template /path/to/your/template/file/here` to use it. Note that Bonnie won't check if the template is valid, it will just blindly copy it (that way, you can have unresolved placeholders or whatever else you want).

If you want to use a file other than `bonnie.toml` to configure Bonnie, you can set the `BONNIE_CONF` environment variable to a relative or absolute path and Bonnie will try to use that instead.

## Your first `bonnie.toml`

1. Create a new configuration with `bonnie -i` in some folder.
2. Paste the following code in, ignoring what's already in there.

```toml
version = "0.3.2"

[scripts]
test = "echo Test"
foobar = "echo \"Foo and Bar\""
```

Now try running `bonnie test` in the same folder. You should see `Test` printed to the console!

Let's break down what we've just set up. First, we define the version of Bonnie that this file is configured for with the top-level `version` key. This is mandatory in all Bonnie files after v0.2.0, and it helps to ensure compatibility between configuration files and the different versions of Bonnie people may have on their computers.

Then, we define `[scripts]`. This is called a _table_ in TOML, which is very similar to an object in JSON. This is also mandatory in all Bonnie files. Then, we define two scripts, `test` and `foobar`. They both use the simplest Bonnie syntax possible, just key-value definition. They map an _alias_ to a longer command, in this case `test` to `echo Test`. This may not seem too useful yet, but it becomes incredibly powerful when you've got build commands like `cargo watch -w ../../../ -x "run --example test"` that you're running very often! With Bonnie, you could alias that as `example-test` and run `bonnie example-test` to execute that command!

## Onward!

This key-value syntax is the easiest way to use Bonnie, and if you just want this, then you've learned how to use Bonnie! However, Bonnie also supports some extremely powerful syntax that can allow you to nest subcommands, interpolate environment variables, and execute commands in a variable order automatically. Keep reading to learn more! From the next document, every page deals with a specific feature of Bonnie, and there'll be a code example at the top with a full explanation thereof and an in-depth discussion of the feature! Enjoy!
